/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1990, 1991, 1992, 1993, 1994 and 1995   *
* by Cadence Design Systems .                                                 *
* All Rights Reserved.                                                        *
*******************************************************************************/

/*

LIBRARY        : Altera synthesis library
FUNCTION       : 8 bit barrel shifter with parallel load
                 
DESIGNER       : Udi Landen
DATE GENERATED : 8th Jan 1995 

VERITOOL COMPATIBILITY : Verilog2.0, Veritime1.4

*/
      
`timescale  1 ns / 100 ps 
`celldefine     
module a_shiftreg8(q, clk, clrn, d, s0, s1, slsi, srsi );
  output[7:0]	q;
  input[7:0]	d;
  input		clk, clrn, s0, s1, slsi, srsi;

  reg[7:0]	q_int;

  buf #1 (q[0], q_int[0]);
  buf #1 (q[1], q_int[1]);
  buf #1 (q[2], q_int[2]);
  buf #1 (q[3], q_int[3]);
  buf #1 (q[4], q_int[4]);
  buf #1 (q[5], q_int[5]);
  buf #1 (q[6], q_int[6]);
  buf #1 (q[7], q_int[7]);
 
  always @(posedge clk)
	case ( {s1,s0} )
		2'b00: q_int = q;			/* no change */
		2'b01: q_int = { srsi, q[7:1] };	/* shift right */
		2'b10: q_int = { q[6:0], slsi };	/* shift left */
		2'b11: q_int = d;			/* load */
	endcase

  always @(clrn)
	if (!clrn) /* async clear */
		assign q_int = 8'b0;
	else
		deassign q_int;

  specify

`ifdef SYNTH
	specparam area = 8;
`endif

  endspecify
 
endmodule
`endcelldefine



